package MusicLandscape.entities;

/**
 * This class represents an artist of performing arts, like a band.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet01
 */
public class Artist {
    /**
     * holds the name of the artist initial value should be unchanged
     *
     * @since ExerciseSheet01
     */
    private String name;

    /**
     * gets the name of this artist.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * sets the name of this artist.
     * <p>
     * the name of an artist cannot be null or empty. if an invalid argument is passed to the method the state of the object remains unchanged
     *
     * @param name the new name of the artist
     */
    public void setName(String name) {
        if (name == null || name.isBlank()) {
            return;
        }
        this.name = name;
    }
}
